/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.util.BufferPool;
import com.kenai.jaffl.util.SimpleBufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBufferPool
implements BufferPool {
    private final int maxBufferSize;
    private final int maxItemsPerSize;
    private final int maxPoolIndex;
    private SimpleBufferPool[] pools;

    public MultiBufferPool(int n, int n2, boolean bl) {
        this.maxBufferSize = n;
        this.maxItemsPerSize = n2;
        this.maxPoolIndex = MultiBufferPool.getSizeIndex(n);
        this.pools = new SimpleBufferPool[this.maxPoolIndex + 1];
        for (int i = 0; i <= this.maxPoolIndex; ++i) {
            this.pools[i] = bl ? new SynchronizedPool(1 << i, n2) : new SimpleBufferPool(1 << i, n2);
        }
    }

    public MultiBufferPool(int n, int n2) {
        this(n, n2, false);
    }

    private static final int getSizeIndex(int n) {
        int n2 = 0;
        int n3 = n;
        if (n3 > 65535) {
            n2 += 16;
            n3 >>= 16;
        }
        if (n3 > 255) {
            n2 += 8;
            n3 >>= 8;
        }
        if (n3 > 15) {
            n2 += 4;
        }
        for (int i = n2; i < 32; ++i) {
            if (1 << i < n) continue;
            return i;
        }
        return 32;
    }

    @Override
    public ByteBuffer get(int n) {
        int n2 = MultiBufferPool.getSizeIndex(n);
        if (n2 <= this.maxPoolIndex) {
            return this.pools[n2].get(n);
        }
        return ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
    }

    @Override
    public void put(ByteBuffer byteBuffer) {
        int n = MultiBufferPool.getSizeIndex(byteBuffer.capacity());
        if (n <= this.maxPoolIndex) {
            this.pools[n].put(byteBuffer);
        }
    }

    @Override
    public void putAll(List<ByteBuffer> list) {
        for (ByteBuffer byteBuffer : list) {
            this.put(byteBuffer);
        }
    }

    static class SynchronizedPool
    extends SimpleBufferPool {
        public SynchronizedPool(int n, int n2) {
            super(n, n2);
        }

        public synchronized ByteBuffer get(int n) {
            return super.get(n);
        }

        public synchronized void put(ByteBuffer byteBuffer) {
            super.put(byteBuffer);
        }
    }
}

